<?php
    /**
    *
    * copyright (c) 2013-2024 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "include/costanti.php";
    include "include/util.php";
    include "gUtil/DbManager.php";
    include "gUtil/SocialSharer.php";
    include "gUtil/GestoreTraduzioni.php";
    include "template/stile.php";
    include "classi/GeneratoreUrl.php";
    include "classi/ecommerce/Carrello.php";
    include "classi/GestoreJavascript.php";
    include "template/include/includeClassiTemplate.php";

    //i dati del database sono definiti nel file costanti.php
    $geecomDb = new DbManager($costantiDatabase);		
    $gestoreJavascript = new GestoreJavascript();

    $impostazioni          = recuperaImpostazioni($geecomDb);
    $impostazioniPagamenti = $geecomDb->leggiSingolaRiga("geecEc_impostazioniPagamenti",1);
    $configurazioneAspetto = $geecomDb->leggiSingolaRiga("geec_configurazioniAspetto","si","selezionataCms");
    $datiCookie    = $geecomDb->leggiSingolaRiga("geecB_leggeCookie",1);
    $profiliSocial = $geecomDb->leggiSingolaRiga("geec_profiliSocial",1);
    $inclusioni    = $geecomDb->leggiSingolaRiga("geecB_inclusioni",1);

    // recupera lo stile scelto, la variabile aspettiSito è contenuta nel file stile.php
    $aspettoSito = $aspettiSito[$impostazioni["aspettoSito"]];
    
    session_start();
    if(isset($_SESSION["carrello"])) { //se il campo passato in input è effettivamente un numero allora fa la query
        $carrello = new Carrello($geecomDb,$_SESSION["carrello"]);
        $carrello->caricaDatiDalDatabase();
        if(isset($_SESSION["geecomUser_id"])) {
            $sessioneUtente = $_SESSION["geecomUser_id"];
            $carrello->setIdUtente($_SESSION["geecomUser_id"]);
        }
        else {
            $sessioneUtente = 0;
        }
		
	$lingua = $carrello->determinaLinguaCarrello();
	$gestoreTraduzioni  = new GestoreTraduzioni("localizzazione", array($lingua));
	$gestoreTraduzioni->caricaTraduzioni();
	$paginaCarrello = new PaginaCarrello($geecomDb,$_SESSION["carrello"],$gestoreTraduzioni,$lingua);
    }
    else {
        $carrello = new Carrello($geecomDb,0);
        $sessioneUtente = 0;

	$lingua = $carrello->determinaLinguaCarrello();
	$gestoreTraduzioni  = new GestoreTraduzioni("localizzazione", array($lingua));
	$gestoreTraduzioni->caricaTraduzioni();
	$paginaCarrello = new PaginaCarrello($geecomDb,0,$gestoreTraduzioni,$lingua);
    }

    $impostazioniCarrello = $geecomDb->leggiSingolaRiga("geecEc_impostazioniPaginaCarrello",1);
?>
<!DOCTYPE html>
<html lang="en">
    <head>
        <?php 
            echo $inclusioni["inizioHead"]; 
        ?>

        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="description" content="">
        <meta name="author" content="">

        <title>Carrello</title>
        <?php 
            include "include/includeCssBase.php"; 

            echo $inclusioni["fineHead"]; 
        ?>
    </head>

    <body class="<?php echo $aspettoSito["body"]; ?> <?php echo(($impostazioni["attivaBarraSuperiore"]=="si") ? "extraspace" : ""); ?>">
        <?php

            include "template/include/aspetto/{$aspettoSito["cartellaTemplatePagina"]}/templatePagina/paginaCarrello.php";

            include "template/include/elementiAggiuntiviTemplate.php";

            include "include/includeJsBase.php";
            UtilTemplate::stampaScrollTop();

            echo $inclusioni["fineBody"];
        ?>
    </body>
</html>
